FUNCTION_BLOCK PMC_AutoRefresh
	IF Enable = TRUE THEN
		(*Read current frame count*)
		memcpy(pDest := ADR(FrmCount),pSrc := ADR(FBin_pointer) + P2H_START + P2H_FRMC_OFFSET,length := 1);
	    
		(*Tick up frame count*)
		FrmCount := FrmCount + 1;
		memcpy(pDest := ADR(FBout_pointer) + H2P_START + H2P_FRMC_OFFSET,pSrc := ADR(FrmCount),length := 1);
	    
	    
		(*Update PMCDB_pointer with newest xbot muxed position*)
		(*read muxed xbot ID*)
		memcpy(pDest := ADR(curXID),pSrc := ADR(FBin_pointer) + P2H_START + P2H_MUX_OFFSET,length := 1);
	    
		(*if current xbotID is valid, update PMCDB_pointer with newest xbot muxed position*)
		IF curXID > 0 AND curXID <= 256 THEN
			(*read X position from frame*)
			memcpy(pDest := ADR(PMCDB_pointer.PosX[curXID - 1] ),pSrc := ADR(FBin_pointer) + P2H_START + P2H_MUX_OFFSET + 4,length := 4);
	        
			(*read Y position from frame*)
			memcpy(pDest := ADR(PMCDB_pointer.PosY[curXID - 1] ),pSrc := ADR(FBin_pointer) + P2H_START + P2H_MUX_OFFSET + 8,length := 4);
	        
			(*read Z position from frame*)
			memcpy(pDest := ADR(PMCDB_pointer.PosZ[curXID - 1] ),pSrc := ADR(FBin_pointer) + P2H_START + P2H_MUX_OFFSET + 12,length := 4);
	        
			(*read RX position from frame*)
			memcpy(pDest := ADR(PMCDB_pointer.PosRx[curXID - 1] ),pSrc := ADR(FBin_pointer) + P2H_START + P2H_MUX_OFFSET + 16,length := 4);
	        
			(*read RY position from frame*)
			memcpy(pDest := ADR(PMCDB_pointer.PosRy[curXID - 1] ),pSrc := ADR(FBin_pointer) + P2H_START + P2H_MUX_OFFSET + 20,length := 4);
	        
			(*read RZ position from frame*)
			memcpy(pDest := ADR(PMCDB_pointer.PosRz[curXID - 1] ),pSrc := ADR(FBin_pointer) + P2H_START + P2H_MUX_OFFSET + 24,length := 4);
	        
			Valid := TRUE;
		ELSE
			Valid := FALSE;
		END_IF;
	ELSE
		Valid := FALSE;
	END_IF;
END_FUNCTION_BLOCK
